# PYTHON & PASCO: Luftmotstand med muffinsformer i fritt fall
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *
import pandas as pd

# -----------------------Rediger fra her--------------------------------------
# Filnavnet til dataene
filnavn = "luftmotstand-muffinsformer.csv"

# Tilpassing av dataene til området vi ønsker å analysere
startpunkt_data = 11    # Hvor langt ut i datasettet vi setter første punkt
sluttpunkt_data = 38    # Hvor langt ut i datasettet vi setter siste punkt

# Konstanter til bruk i modell
m = 0.30*10**(-3)       # Masse, kg
g = 9.81                # Tyngdeakselerasjon, m/s^2
k = 0.0017              # Luftmotstandstallet, kg/m
dt = 0.0001             # Tidssteget som brukes i simuleringen

# Akselerasjonsfunksjon
def a(v):
    # Utregning av krefter
    G = m*g             # Tyngdekraft, N
    L = k*v**2          # Luftmotstand, N

    # Slippes formen fra under sensor skal sum_F = G - L
    # Slippes formen fra over sensor skal sum_F = L - G
    sum_F = L - G       # Kraftsum, N
    aks = sum_F/m       # Akselerasjon, m/s^2
    return aks

# ----------------------Ikke rediger under------------------------------------

# Importering av data
csv_data = pd.read_csv(open(filnavn, 'r'), delimiter=";", decimal=",")
t_data = csv_data.iloc[:,1].to_numpy()
s_data = csv_data.iloc[:,2].to_numpy()
t_data = t_data[~isnan(t_data)]
s_data = s_data[~isnan(s_data)]

# Tilpassing av datasett utifra startpunkt og sluttpunkt
t_data = t_data[startpunkt_data:sluttpunkt_data];
t_data = t_data - t_data[0]
s_data = s_data[startpunkt_data:sluttpunkt_data]

# Start-/sluttverdier og oppretting av lister for simuleringsdata
s = s_data[0]       # Startposisjon synkroniseres med måledata
v = 0               # Startfart muffinsformen
t = 0               # Starttidspunkt

s_sim = [s]         # Legger startposisjon i liste
v_sim = [v]         # Legger startfart i liste
t_sim = [t]         # Legger starttid i liste

t_slutt = t_data[-1]    # Avslutter simuleringen ved siste datapunkt.

# Løkke for simulering av bevegelsen
while t < t_slutt:      # Så lenge muffinsformen faller
    v = v + a(v)*dt     # Regner ut neste fart, overskriver gammel
    s = s + v*dt        # Regner ut neste posisjon, overskriver gammel
    t = t + dt          # Regner ut neste tidspunkt

    v_sim.append(v)     # Lagrer den nye farten i liste
    s_sim.append(s)     # Lagrer den nye posisjonen i liste
    t_sim.append(t)     # Lagrer den nye tiden i liste

# Plot av data mot modell
plot(t_data,s_data,'gx')                # Plotter måledataene som punkter
plot(t_sim,s_sim)                       # Plotter simuleringen
xlabel('Tid / s')                       # Navn på x-aksen
ylabel('Posisjon / m')                  # Navn på y-aksen
title('Posisjonsgraf for muffinsform')  # Tittal på plottet
legend(['Måledata','Modell'])           # Etiketter for graf og punkter
grid()                                  # Tegner rutenett
show()                                  # Viser grafvinduet
